<?php
// Teste simples da API Moonfy
header('Content-Type: text/plain');

const SECRET_KEY = 'sk_live_v2qH1vr3VkJhw3XBI3bkOMjOiuVO7qcbcBDHdUxjEq';
const API_BASE_URL = 'https://api.moonfy.com.br/v1';

echo "=== TESTE SIMPLES MOONFY ===\n";
echo "Secret Key: " . SECRET_KEY . "\n";
echo "API Base URL: " . API_BASE_URL . "\n";

// Testar conectividade básica
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, API_BASE_URL . '/transactions');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Basic ' . base64_encode(SECRET_KEY . ':')
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Code: " . $httpCode . "\n";
echo "Response: " . $response . "\n";
echo "Error: " . $error . "\n";

// Testar com diferentes formatos de autenticação
echo "\n=== TESTANDO DIFERENTES FORMATOS ===\n";

$formats = [
    'Basic ' . base64_encode(SECRET_KEY . ':'),
    'Basic ' . base64_encode(SECRET_KEY . ':x'),
    'Bearer ' . SECRET_KEY,
    SECRET_KEY
];

foreach ($formats as $i => $auth) {
    echo "Formato " . ($i + 1) . ": " . $auth . "\n";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, API_BASE_URL . '/transactions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: ' . $auth
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "  HTTP Code: " . $httpCode . "\n";
    echo "  Response: " . substr($response, 0, 100) . "\n\n";
}
?>
