<?php
// Teste final da API Moonfy
header('Content-Type: text/plain');

// Credenciais exatas fornecidas pelo usuário
$secret_key = 'sk_live_v2qH1vr3VkJhw3XBI3bkOMjOiuVO7qcbcBDHdUxjEq';
$public_key = 'pk_live_v2Mnp0PFV68jvNRFzYAmauvn2N4kjuYDq';

echo "=== TESTE FINAL MOONFY ===\n";
echo "Secret Key: " . $secret_key . "\n";
echo "Public Key: " . $public_key . "\n\n";

// Testar com dados mínimos
$paymentData = [
    'amount' => 1000, // R$ 10,00 em centavos
    'paymentMethod' => 'pix',
    'customer' => [
        'name' => 'João Silva',
        'email' => 'teste@email.com',
        'phone' => '11999999999',
        'document' => [
            'number' => '11144477735',
            'type' => 'cpf'
        ]
    ],
    'items' => [
        [
            'title' => 'Teste PIX',
            'unitPrice' => 1000,
            'quantity' => 1,
            'tangible' => false
        ]
    ]
];

echo "Dados de teste:\n";
echo json_encode($paymentData, JSON_PRETTY_PRINT) . "\n\n";

// Testar diferentes formatos de autenticação
$authFormats = [
    'Basic ' . base64_encode($secret_key . ':x'),
    'Basic ' . base64_encode($secret_key . ':'),
    'Bearer ' . $secret_key,
    $secret_key
];

foreach ($authFormats as $i => $auth) {
    echo "=== TESTE " . ($i + 1) . " ===\n";
    echo "Auth: " . $auth . "\n";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://api.moonfy.com.br/v1/transactions');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($paymentData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: ' . $auth
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    echo "HTTP Code: " . $httpCode . "\n";
    echo "Error: " . $error . "\n";
    echo "Response: " . $response . "\n\n";
    
    if ($httpCode === 200 || $httpCode === 201) {
        echo "✅ SUCESSO! Formato correto encontrado.\n";
        break;
    }
}

// Verificar se as credenciais estão ativas
echo "=== VERIFICAÇÃO DE STATUS DAS CREDENCIAIS ===\n";
echo "As credenciais podem estar:\n";
echo "1. Incorretas\n";
echo "2. Inativas/Expiradas\n";
echo "3. Usando formato de autenticação diferente\n";
echo "4. API em manutenção\n\n";

echo "Recomendações:\n";
echo "1. Verificar se as credenciais estão corretas no painel da Moonfy\n";
echo "2. Verificar se a conta está ativa\n";
echo "3. Verificar se há restrições de IP\n";
echo "4. Entrar em contato com o suporte da Moonfy\n";
?>
