<?php
// Teste da geração de emails
require_once 'gerar-pix-moonfy.php';

echo "<h1>Teste de Geração de Emails</h1>";

// Testar com diferentes nomes
$nomes = [
    'João Silva',
    'Maria Santos',
    'Pedro Oliveira',
    'Ana Costa',
    'Carlos Eduardo',
    'Fernanda',
    'José da Silva',
    'Mariana de Oliveira',
    'Antônio Carlos',
    'Beatriz'
];

echo "<h2>Testando geração de emails:</h2>";
echo "<table border='1' cellpadding='5' cellspacing='0'>";
echo "<tr><th>Nome</th><th>Email Gerado</th></tr>";

foreach ($nomes as $nome) {
    $email = gerarEmailCliente($nome);
    echo "<tr><td>$nome</td><td>$email</td></tr>";
}

echo "</table>";

// Testar geração de PIX com email automático
echo "<h2>Testando geração de PIX com email automático:</h2>";

$testData = [
    'action' => 'gerar_pix',
    'nome' => 'João Silva',
    'cpf' => '11144477735',
    'valor' => 10.00,
    'descricao' => 'Teste PIX com email automático',
    'telefone' => '11999999999'
    // Sem email - será gerado automaticamente
];

echo "<h3>Dados de teste:</h3>";
echo "<pre>" . json_encode($testData, JSON_PRETTY_PRINT) . "</pre>";

$result = gerarPix($testData);

echo "<h3>Resultado:</h3>";
echo "<pre>" . json_encode($result, JSON_PRETTY_PRINT) . "</pre>";

if ($result['success']) {
    echo "<h3>✅ PIX gerado com sucesso!</h3>";
    echo "<p><strong>Transaction ID:</strong> " . $result['transaction_id'] . "</p>";
    echo "<p><strong>Email usado:</strong> " . ($result['raw_response']['customer']['email'] ?? 'N/A') . "</p>";
} else {
    echo "<h3>❌ Erro ao gerar PIX:</h3>";
    echo "<p><strong>Erro:</strong> " . $result['error'] . "</p>";
}
?>
