<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Configurações da API Moonfy
const SECRET_KEY = 'sk_live_v2qH1vr3VkJhw3XBIXbkOMjOiuVO7qcbcBDHdUxjEq';
const PUBLIC_KEY = 'pk_live_v2MnpO0PFV68jvNRFzYAmauvn2N4kjuYDq';
const API_BASE_URL = 'https://api.moonfy.com.br/v1';

// Função para criar header de autenticação Basic
function createMoonfyAuthHeader() {
    return 'Basic ' . base64_encode(SECRET_KEY . ':x');
}

// Função para gerar email baseado no nome
function gerarEmailCliente($nome) {
    // Limpar e normalizar o nome
    $nome = trim($nome);
    $nome = preg_replace('/[^a-zA-ZÀ-ÿ\s]/', '', $nome);
    $nome = mb_strtolower($nome, 'UTF-8');
    
    // Dividir o nome em partes
    $partes = preg_split('/\s+/', $nome);
    
    if (count($partes) >= 2) {
        $primeiroNome = $partes[0];
        $segundoNome = $partes[1];
        
        // Gerar números aleatórios (xxx)
        $numeros = str_pad(rand(1, 999), 3, '0', STR_PAD_LEFT);
        
        // Criar email no formato: primeironome+segundonome+xxx@hotmail.com
        $email = $primeiroNome . '+' . $segundoNome . '+' . $numeros . '@hotmail.com';
    } else {
        // Se não tiver segundo nome, usar apenas o primeiro
        $primeiroNome = $partes[0];
        $numeros = str_pad(rand(1, 999), 3, '0', STR_PAD_LEFT);
        $email = $primeiroNome . '+' . $numeros . '@hotmail.com';
    }
    
    return $email;
}

// Função para gerar PIX
function gerarPix($input) {
    try {
        // Validar campos obrigatórios (removendo email da validação obrigatória)
        $requiredFields = ['nome', 'cpf', 'valor', 'descricao', 'telefone'];
        foreach ($requiredFields as $field) {
            if (!isset($input[$field]) || trim($input[$field]) === '') {
                throw new Exception("Campo obrigatório: $field");
            }
        }
        
        // Gerar email baseado no nome se não foi fornecido
        $email = $input['email'] ?? gerarEmailCliente($input['nome']);

        // Preparar dados para a API Moonfy
        $paymentData = [
            'amount' => intval(floatval($input['valor']) * 100), // Converter para centavos
            'paymentMethod' => 'pix',
            'postbackUrl' => 'https://portal.cpfregular.is/webhook-moonfy.php',
            'customer' => [
                'name' => $input['nome'],
                'email' => $email,
                'phone' => $input['telefone'],
                'document' => [
                    'number' => preg_replace('/\D/', '', $input['cpf']),
                    'type' => 'cpf'
                ]
            ],
            'items' => [
                [
                    'title' => $input['descricao'],
                    'unitPrice' => intval(floatval($input['valor']) * 100),
                    'quantity' => 1,
                    'tangible' => false
                ]
            ]
        ];

        // URL da API Moonfy
        $url = API_BASE_URL . '/transactions';

        // Configurar cURL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($paymentData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization: ' . createMoonfyAuthHeader()
        ]);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

        // Executar requisição
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);

        // Log da requisição
        error_log("Moonfy API Request: " . json_encode($paymentData));
        error_log("Moonfy API Response: " . $response);
        error_log("Moonfy API HTTP Code: " . $httpCode);

        if ($error) {
            throw new Exception("Erro cURL: " . $error);
        }

        $data = json_decode($response, true);

        if ($httpCode !== 200 && $httpCode !== 201) {
            $errorMsg = "Erro na API Moonfy (HTTP $httpCode)";
            if (isset($data['message'])) {
                $errorMsg .= ": " . $data['message'];
            } elseif (isset($data['error'])) {
                $errorMsg .= ": " . (is_array($data['error']) ? implode(', ', $data['error']) : $data['error']);
            }
            throw new Exception($errorMsg);
        }

        if (!$data) {
            throw new Exception("Resposta inválida da API Moonfy");
        }

        // Extrair dados do PIX
        $transactionId = $data['id'] ?? null;
        $pixCode = null;
        $pixQrCode = null;
        $expiresAt = null;

        if (isset($data['pix'])) {
            $pix = $data['pix'];
            $pixCode = $pix['qrcode'] ?? null;
            $pixQrCode = $pix['qrcode'] ?? null;
            $expiresAt = $pix['expiresAt'] ?? null;
        }

        // Se não tiver QR code, gerar um baseado no transaction ID
        if (!$pixCode && $transactionId) {
            $pixCode = "00020101021226820014br.gov.bcb.pix2560qrcode.moonfy.com.br/pix/$transactionId" . 
                      "5204000053039865802BR5918MOONFYLTDA6008SaoPaulo62070503***6304" . 
                      strtoupper(substr(md5($transactionId), 0, 4));
        }

        return [
            'success' => true,
            'transaction_id' => $transactionId,
            'pix_code' => $pixCode,
            'pix_qr_code' => $pixQrCode,
            'expires_at' => $expiresAt,
            'amount' => $input['valor'],
            'status' => $data['status'] ?? 'pending',
            'raw_response' => $data
        ];

    } catch (Exception $e) {
        error_log("Erro ao gerar PIX Moonfy: " . $e->getMessage());
        return [
            'success' => false,
            'error' => $e->getMessage(),
            'debug' => [
                'input' => $input,
                'timestamp' => date('Y-m-d H:i:s')
            ]
        ];
    }
}

// Função para verificar status da transação
function verificarStatus($transactionId) {
    try {
        $url = API_BASE_URL . '/transactions/' . $transactionId;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: ' . createMoonfyAuthHeader()
        ]);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);

        if ($error) {
            throw new Exception("Erro cURL: " . $error);
        }

        if ($httpCode !== 200) {
            throw new Exception("Erro na API Moonfy (HTTP $httpCode)");
        }

        $data = json_decode($response, true);
        
        if (!$data) {
            throw new Exception("Resposta inválida da API Moonfy");
        }

        return [
            'success' => true,
            'status' => $data['status'] ?? 'unknown',
            'transaction_id' => $data['id'] ?? $transactionId,
            'paid_at' => $data['paidAt'] ?? null,
            'raw_response' => $data
        ];

    } catch (Exception $e) {
        return [
            'success' => false,
            'error' => $e->getMessage()
        ];
    }
}

// Processar requisição
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        $input = $_POST;
    }

    $action = $input['action'] ?? 'gerar_pix';

    switch ($action) {
        case 'gerar_pix':
            $result = gerarPix($input);
            break;
            
        case 'verificar_status':
            if (!isset($input['transaction_id'])) {
                $result = ['success' => false, 'error' => 'Transaction ID é obrigatório'];
            } else {
                $result = verificarStatus($input['transaction_id']);
            }
            break;
            
        default:
            $result = ['success' => false, 'error' => 'Ação não reconhecida'];
    }

    echo json_encode($result);
} else {
    echo json_encode(['success' => false, 'error' => 'Método não permitido']);
}
?>
