<?php
// Debug da API Moonfy
header('Content-Type: application/json');

const SECRET_KEY = 'sk_live_v2qH1vr3VkJhw3XBI3bkOMjOiuVO7qcbcBDHdUxjEq';
const API_BASE_URL = 'https://api.moonfy.com.br/v1';

// Função para criar header de autenticação Basic
function createMoonfyAuthHeader() {
    return 'Basic ' . base64_encode(SECRET_KEY . ':x');
}

echo "Secret Key: " . SECRET_KEY . "\n";
echo "Auth Header: " . createMoonfyAuthHeader() . "\n";

// Testar uma requisição simples
$url = API_BASE_URL . '/transactions';

$paymentData = [
    'amount' => 1000, // R$ 10,00 em centavos
    'paymentMethod' => 'pix',
    'customer' => [
        'name' => 'João Silva',
        'email' => 'teste@email.com',
        'phone' => '11999999999',
        'document' => [
            'number' => '11144477735',
            'type' => 'cpf'
        ]
    ],
    'items' => [
        [
            'title' => 'Teste PIX',
            'unitPrice' => 1000,
            'quantity' => 1,
            'tangible' => false
        ]
    ]
];

echo "Request URL: " . $url . "\n";
echo "Request Data: " . json_encode($paymentData, JSON_PRETTY_PRINT) . "\n";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($paymentData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: ' . createMoonfyAuthHeader()
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
curl_setopt($ch, CURLOPT_VERBOSE, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
$info = curl_getinfo($ch);
curl_close($ch);

echo "HTTP Code: " . $httpCode . "\n";
echo "Response: " . $response . "\n";
echo "Error: " . $error . "\n";
echo "Info: " . json_encode($info, JSON_PRETTY_PRINT) . "\n";
?>
